<?php
namespace ServiceObjects\AddressValidation3\Controller\Shipping;

use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\Action;

class Latestdata extends Action
{
    protected $resultJsonFactory;
    protected $quoteRepository;
    protected $quoteIdMaskFactory;

    public function __construct(
        Context $context,
        \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
        \Magento\Quote\Api\CartRepositoryInterface $quoteRepository,
        \Magento\Quote\Model\QuoteIdMaskFactory $quoteIdMaskFactory
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
        $this->quoteRepository = $quoteRepository;
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
    }

    public function execute()
    {
        if($this->getRequest()->isPost()){
            $cartId = $this->getRequest()->getParams()['cartId'];
            $quoteIdMask = $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id');
            if($quoteIdMask->getQuoteId()){
                $cartId = $quoteIdMask->getQuoteId();
            }
            $resultJson = $this->resultJsonFactory->create();
            $response = ['success' => false ];
            try{
                $quote = $this->quoteRepository->getActive($cartId);
                $shippingAddress = $quote->getShippingAddress();
                if($shippingAddress){
                    $response = ['success' => true, 'street' => $shippingAddress->getStreet(), 'city' => $shippingAddress->getCity(), 'region' => $shippingAddress->getRegion(), 'postcode' => $shippingAddress->getPostcode()];
                }
            }
            catch(\Exception $ex){}
            $resultJson->setData($response);
            return $resultJson;
        }
    }
}