<?php
namespace ServiceObjects\AddressValidation3\Plugin;

use Magento\Checkout\Model\ShippingInformationManagement;
use Magento\Checkout\Api\ShippingInformationManagementInterface;
use Exception;
use SimpleXMLElement;


class ValidateShippingAddress
{
    private $_logger;
    protected $cache;
    public function __construct(
        \Psr\Log\LoggerInterface $logger
    ) {
        $this->_logger = $logger;
    }


    public function beforeSaveAddressInformation(
        \Magento\Checkout\Model\ShippingInformationManagement $subject,
        $cartId,
        \Magento\Checkout\Api\Data\ShippingInformationInterface $addressInformation
    )
    {
        $street = $addressInformation->getShippingAddress()->getStreet();
        $city = $addressInformation->getShippingAddress()->getCity();
        $state = $addressInformation->getShippingAddress()->getRegion();
        $postcode = $addressInformation->getShippingAddress()->getPostcode();

        $av3 = $this->GetBestMatches('', $street[0], '' , $city, $state, $postcode, 'YOUR_LICENSEKEY', false);
        
        if(!isset($av3->Error))
        {
            $addressInformation->getShippingAddress()->setStreet([$av3->Addresses->Address[0]->Address1, '', '']);
            $addressInformation->getShippingAddress()->setCity($av3->Addresses->Address[0]->City);
            $addressInformation->getShippingAddress()->setRegion($av3->Addresses->Address[0]->State);
            $addressInformation->getShippingAddress()->setPostcode($av3->Addresses->Address[0]->Zip);
        }

        $return = [$cartId, $addressInformation];
    
        return $return;
    }

    private function callURL($urlRequest)
    {
        $curlClient = curl_init($urlRequest);
        curl_setopt_array($curlClient, array(CURLOPT_RETURNTRANSFER => 1, CURLOPT_URL => $urlRequest));
        curl_setopt($curlClient, CURLOPT_TIMEOUT, 30);
        $urlResponse = curl_exec($curlClient);
        
        if ($urlResponse)
        {
            $output = new SimpleXMLElement($urlResponse);
        }
        else
        {
            throw new Exception('Curl ERROR: '.curl_error($curlClient).' Curl Error No: '.curl_errno($curlClient));				
        }

        curl_close($curlClient);

        return $output;
    }

    private function GetBestMatches($BusinessName, $Address, $Address2, $City, $State, $PostalCode, $LicenseKey, $IsLiveKey)
    {
        $response = null;

        $BusinessName = (is_null($BusinessName)) ? '' : $BusinessName;
        $Address = (is_null($Address)) ? '' : $Address;
        $Address2 = (is_null($Address2)) ? '' : $Address2;
        $City = (is_null($City)) ? '' : $City;
        $State = (is_null($State)) ? '' : $State;
        $PostalCode = (is_null($PostalCode)) ? '' : $PostalCode;
        $LicenseKey = (is_null($LicenseKey)) ? '' : $LicenseKey;

        $queryRequest = 'BusinessName='.urlencode($BusinessName).'&Address='.urlencode($Address).'&Address2='.urlencode($Address2).'&City='.urlencode($City).'&State='.urlencode($State).'&PostalCode='.urlencode($PostalCode).'&LicenseKey='.urlencode($LicenseKey);

            if($IsLiveKey)
            {
                try 
                {
                    $response = $this->callURL('https://ws.serviceobjects.com/av3/api.svc/GetBestMatches?'.$queryRequest);

                    if($response == null || ($response->Error != null && $response->Error->TypeCode == "3"))
                    {
                        throw new Exception('Error Processing Request');
                    }
                }
                catch (exception $ex)
                {
                    $response = $this->callURL('https://wsbackup.serviceobjects.com/av3/api.svc/GetBestMatches?'.$queryRequest);
                }
            }
            else
            {
                try 
                {
                    $response = $this->callURL('https://trial.serviceobjects.com/av3/api.svc/GetBestMatches?'.$queryRequest);

                    if($response == null || ($response->Error != null && $response->Error->TypeCode == "3"))
                    {
                        throw new Exception('Error Processing Request');
                    }
                }
                catch (exception $ex)
                {	
                    $response = $this->callURL('https://trial.serviceobjects.com/av3/api.svc/GetBestMatches?'.$queryRequest);
                }
            }

            return $response;			
    }

    
}