﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Script.Serialization;
using System.Web.Services;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AC
{
    public partial class AVIHandler : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        static int WEB_SERVICE_REQUEST_TIMEOUT; //In milliseconds
        static string Key = "";

        [WebMethod]
        public static string ValidateAddressLive(string Address1, string Address2, string Address3, string Address4, string Address5, string Locality, string AdministrativeArea, string PostalCode, string Country, string OutputLanguage)
        {
            AVITrial.AVISoapServiceClient ws = new AVITrial.AVISoapServiceClient();
            AVITrial.AddressInfoResponse response = default(AVITrial.AddressInfoResponse);
            try
            {
                Key = ConfigurationManager.AppSettings["AVIKey"];
                WEB_SERVICE_REQUEST_TIMEOUT = Convert.ToInt32(ConfigurationManager.AppSettings["WebServiceRequestTimeout"]);
                ws.InnerChannel.OperationTimeout = new TimeSpan(0, 0, 0, WEB_SERVICE_REQUEST_TIMEOUT);
                response = ws.GetAddressInfo(Address1, Address2, Address3, Address4, Address5, Locality, AdministrativeArea, PostalCode, Country, OutputLanguage, Key);
                if (response == null)
                {
                    return "";
                }
                string json = new JavaScriptSerializer().Serialize(response);
                return json;
            }
            catch (Exception e)
            {

                return "";
            }
            finally
            {
                if (ws != null) { ws.Close(); }
            }
        }



        [WebMethod]
        public static string ValidateAddressBackup(string Address1, string Address2, string Address3, string Address4, string Address5, string Locality, string AdministrativeArea, string PostalCode, string Country, string OutputLanguage)
        {
            AVITrialBackup.AVISoapServiceClient ws = new AVITrialBackup.AVISoapServiceClient();
            AVITrialBackup.AddressInfoResponse response = default(AVITrialBackup.AddressInfoResponse);
            try
            {
                Key = ConfigurationManager.AppSettings["AVIKey"];
                WEB_SERVICE_REQUEST_TIMEOUT = Convert.ToInt32(ConfigurationManager.AppSettings["WebServiceRequestTimeout"]);
                ws.InnerChannel.OperationTimeout = new TimeSpan(0, 0, 0, WEB_SERVICE_REQUEST_TIMEOUT);
                response = ws.GetAddressInfo(Address1, Address2, Address3, Address4, Address5, Locality, AdministrativeArea, PostalCode, Country, OutputLanguage, Key);
                if (response == null)
                {
                    return "";
                }
                string json = new JavaScriptSerializer().Serialize(response);
                return json;
            }
            catch (Exception e)
            {

                return "";
            }
            finally
            {
                if (ws != null) { ws.Close(); }
            }
        }
    }
}