﻿var fields = [
    { element: "iAddress1", field: "Address1", mode: so.fieldMode.SEARCH | so.fieldMode.POPULATE },
    { element: "iAddress2", field: "Address2", mode: so.fieldMode.POPULATE },
    { element: "iAddress3", field: "Address3", mode: so.fieldMode.POPULATE },
    { element: "iAddress4", field: "Address4", mode: so.fieldMode.POPULATE },
    { element: "iAddress5", field: "Address5", mode: so.fieldMode.POPULATE },
    { element: "iUnits", field: "SubPremise", mode: so.fieldMode.POPULATE },
    { element: "iLocality", field: "Locality", mode: so.fieldMode.POPULATE },
    { element: "iAdminArea", field: "AdminArea", mode: so.fieldMode.POPULATE },
    { element: "iPostal", field: "PostalCode", mode: so.fieldMode.POPULATE },
    { element: "iCountry", field: "Country", mode: so.fieldMode.COUNTRY }
];

var CustomKey = "EAE234694F2647AB92163EF93EB00D7B";
var options = { key: CustomKey, isTrial: false, setCountryByIP: true, manualEntry: true };


var DOTSGlobalAddressComplete = new so.Address(fields, options);

DOTSGlobalAddressComplete.listen("populate", function (address, variations) {

    var Address = '';
    var Address2 = '';
    var Address3 = '';
    var Address4 = '';
    var Address5 = '';
    var Locality = '';
    var AdministrativeArea = '';
    var PostalCode = '';
    var Country = '';
    var Language = '';

    Address = address.Address1;
    Address2 = address.Address2;
    Address3 = address.Address3;
    Address4 = address.Address4;
    Address5 = address.Address5;
    Locality = address.Locality;
    AdministrativeArea = address.AdminArea;
    PostalCode = address.PostalCode;
    Country = address.CountryIso3;
    Language = 'English';



    CallAddressValidationInternational(Address, Address2, Address3, Address4, Address5, Locality, AdministrativeArea, PostalCode, Country, Language, address);

    
});

$(document).ready(function () {

    $('#cb').click(function (event) {
        if ($('#cb').is(':checked')) {
            options = { key: CustomKey, isTrial: true, setCountryByIP: true };
            DOTSGlobalAddressComplete = new so.Address(fields, options);
        }
        else {
            options = { key: CustomKey, isTrial: true, Validate: false, setCountryByIP: true };
            DOTSGlobalAddressComplete = new so.Address(fields, options);
        }

        DOTSGlobalAddressComplete.listen("populate", function (address, variations) {
            document.getElementById("LabelJSON").innerText = address.FormattedAddress;
            document.getElementById("FullResponseJSON").innerText = JSON.stringify(address, null, '\t');
            if ($('#ExpLabel').hasClass('Hide')) {
                $('#ExpLabel').removeClass('Hide').addClass('Show');
            }
            if ($('#ExpResponse').hasClass('Hide')) {
                $('#ExpResponse').removeClass('Hide').addClass('Show');
            }
        });
    });

    $('.block1').click(function (event) {
        if ($('#ExpLabel').hasClass('Show')) {
            $('#ExpLabel').removeClass('Show').addClass('Hide');
        }
        else {
            $('#ExpLabel').removeClass('Hide').addClass('Show');
        }
    });

    $('.block3').click(function (event) {
        if ($('#ExpResponse').hasClass('Show')) {
            $('#ExpResponse').removeClass('Show').addClass('Hide');
        }
        else {
            $('#ExpResponse').removeClass('Hide').addClass('Show');
        }
    });
});

function CallAddressValidationInternational(Address, Address2, Address3, Address4, Address5, Locality, AdministrativeArea, PostalCode, Country, Language, address) {

    var Data = '{Address1: "' + Address + '", Address2: "' + Address2 + '", Address3: "' + Address3 + '", Address4: "' + Address4 + '", Address5: "' + Address5 + '", Locality: "' + Locality + '", AdministrativeArea: "' + AdministrativeArea + '", PostalCode: "' + PostalCode + '", Country: "' + Country + '", OutputLanguage: "' + Language + '"}';
    if (Country == "USA")
    {
        document.getElementById("LabelJSON").innerText = address.FormattedAddress;
        document.getElementById("FullResponseJSON").innerText = JSON.stringify(address, null, '\t');
        if ($('#ExpLabel').hasClass('Hide')) {
            $('#ExpLabel').removeClass('Hide').addClass('Show');
        }
        if ($('#ExpResponse').hasClass('Hide')) {
            $('#ExpResponse').removeClass('Hide').addClass('Show');
        }
    }
    else {
        $.ajax(
        {
            type: "POST",
            url: "AVIHandler.aspx/ValidateAddressLive",
            data: Data,
            contentType: "application/json; charset=utf-8",
            success: function (response) {
                if (response.d !== "") {

                    var statResult = JSON.parse(response.d)
                    document.getElementById("LabelJSON").innerText = address.FormattedAddress;
                    document.getElementById("FullResponseJSON").innerText = JSON.stringify(address, null, '\t') + '\r\n\r\n' + JSON.stringify(statResult, null, '\t');
                    if ($('#ExpLabel').hasClass('Hide')) {
                        $('#ExpLabel').removeClass('Hide').addClass('Show');
                    }
                    if ($('#ExpResponse').hasClass('Hide')) {
                        $('#ExpResponse').removeClass('Hide').addClass('Show');
                    }
                }
            },
            error: function (e) {
                $.ajax({
                    type: "POST",
                    url: "AVIHandler.aspx/ValidateAddressBackUp",
                    data: Data,
                    contentType: "application/json; charset=utf-8",
                    success: function (response) {
                        if (response.d !== "") {

                            var statResult = JSON.parse(response.d)
                            document.getElementById("LabelJSON").innerText = address.FormattedAddress;
                            document.getElementById("FullResponseJSON").innerText = JSON.stringify(address, null, '\t') + '\r\n\r\n' + JSON.stringify(statResult, null, '\t');
                            if ($('#ExpLabel').hasClass('Hide')) {
                                $('#ExpLabel').removeClass('Hide').addClass('Show');
                            }
                            if ($('#ExpResponse').hasClass('Hide')) {
                                $('#ExpResponse').removeClass('Hide').addClass('Show');
                            }
                        }
                    },
                    error: function (e) {
                    }
                });
            }
        }); 
    }
}