global class AddressValidationCanada2 implements Process.Plugin{
    global Process.PluginResult invoke(Process.PluginRequest request) { 
		String Address1 = (String) request.inputParameters.get('Address 1');
		String Address2 = (String) request.inputParameters.get('Address 2');
		String City = (String) request.inputParameters.get('City');
		String Province = (String) request.inputParameters.get('Province');
		String PostalCode = (String) request.inputParameters.get('Postal Code');
		
		if(Address1 == null || Address1 == '')
		{
			Address1 = ' ';
		}
		if(Address2 == null || Address2 == '')
		{
			Address2 = ' ';
		}
		if(City == null || City == '')
		{
			City = ' ';
		}
		if(Province == null || Province == '')
		{
			Province = ' ';
		}
		if(PostalCode == null || PostalCode == '')
		{
			PostalCode = ' ';
		}
		
		String ServiceObjectsResult = CallServiceObjectsAPI(Address1, Address2, City, Province, PostalCode);
		
 		Map<String,Object> result = new Map<String,Object>();
        Map<String,Object> resultUntyped = (Map<String,Object>)JSON.deserializeUntyped(ServiceObjectsResult);
        Object Address = (Object)resultUntyped.get('CanadianAddressInfoV2');
		
	
		if(Address != null)
		{
        	Map<String,Object> addressUntyped = (Map<String,Object>)Address;
        	if(addressUntyped != null)
	        {
        		result.put('Address 1', addressUntyped.get('Address'));
        		result.put('Address 2', addressUntyped.get('Address2'));
        		result.put('City', addressUntyped.get('Municipality'));
        		result.put('Province', addressUntyped.get('Province'));
        		result.put('Postal Code', addressUntyped.get('PostalCode'));
        		result.put('Time Zone', addressUntyped.get('TimeZone'));
        		result.put('Is PO Box', addressUntyped.get('IsPOBox'));
        		result.put('Station Info', addressUntyped.get('StationInfo'));
        		result.put('Delivery Mode', addressUntyped.get('DeliveryMode'));
        		result.put('Delivery Installation', addressUntyped.get('DeliveryInstallation'));
        		result.put('Corrections', addressUntyped.get('Corrections'));
        		result.put('Corrections Description', addressUntyped.get('CorrectionsDesc'));
        		result.put('Address Number Fragment', addressUntyped.get('AddressNumberFragment'));
        		result.put('Street Name Fragment', addressUntyped.get('StreetNameFragment'));
        		result.put('Street Type Fragment', addressUntyped.get('StreetTypeFragment'));
        		result.put('Directional Code Fragment', addressUntyped.get('DirectionalCodeFragment'));
        		result.put('Unit Type Fragment', addressUntyped.get('UnitTypeFragment'));
        		result.put('Unit Number Fragment', addressUntyped.get('UnitNumberFragment'));
        		result.put('Box Number Fragment', addressUntyped.get('BoxNumberFragment'));
        		System.debug(result);
	        }
		}
		else
		{
			Object Error = (Object)resultUntyped.get('Error');
			if(Error != null)
			{
				Map<String,Object> errorUntyped = (Map<String,Object>)Error; 
				if(errorUntyped != null)
			    {
			    	result.put('Error Type', errorUntyped.get('Type'));
	        		result.put('Error Type Code', errorUntyped.get('TypeCode'));
	        		result.put('Error Description', errorUntyped.get('Desc'));
	        		result.put('Error Description Code', errorUntyped.get('DescCode'));
			    }
			}
			else
			{
				Object NetworkError = (Object)resultUntyped.get('NetworkError');
				if(NetworkError != null)
				{
					Map<String,Object> networkErrorUntyped = (Map<String,Object>)NetworkError; 
					if(networkErrorUntyped != null)
				    {
				    	result.put('Network Connection Error', networkErrorUntyped.get('Message'));
				    }
				}
			}
		}
        return new Process.PluginResult(result); 
    }
    
    private String CallServiceObjectsAPI(String Address1, String Address2, String City, String Province, String PostalCode)
    {
    	Http h;
		HttpRequest req;
		HttpResponse res;
		String requestURL = 'https://trial.serviceobjects.com/AVCA2/api.svc/CanadianAddressV2/'	+ EncodingUtil.urlEncode(PostalCode,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Province,'UTF-8').replaceAll('\\+','%20') + '/'	+ EncodingUtil.urlEncode(City,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address2,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address1,'UTF-8').replaceAll('\\+','%20') + '/ws71-XXXX-XXXX?format=json';

		try
		{
			h = new Http();
			req = new HttpRequest();
			req.setEndpoint(requestURL);
			req.setMethod('GET');
			res = h.send(req);
			Map<String,Object> resultUntyped = (Map<String,Object>)JSON.deserializeUntyped(res.getBody());
			Object Error = (Object)resultUntyped.get('Error');
			
			if(Error != null)
		    {
		    	Map<String,Object> errorUntyped = (Map<String,Object>)Error; 
		    	if(errorUntyped != null && errorUntyped.get('TypeCode') == '3')
		    	{
			    	requestURL = 'https://trial.serviceobjects.com/AVCA2/api.svc/CanadianAddressV2/'	+ EncodingUtil.urlEncode(PostalCode,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Province,'UTF-8').replaceAll('\\+','%20') + '/'	+ EncodingUtil.urlEncode(City,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address2,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address1,'UTF-8').replaceAll('\\+','%20') + '/ws71-XXXX-XXXX?format=json';
					h = new Http();
					req = new HttpRequest();
					req.setEndpoint(requestURL);
					req.setMethod('GET');
					res = h.send(req);
		    	}
		    }
		}
		catch(Exception Ex)
		{
			try
			{
				requestURL = 'https://trial.serviceobjects.com/AVCA2/api.svc/CanadianAddressV2/'	+ EncodingUtil.urlEncode(PostalCode,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Province,'UTF-8').replaceAll('\\+','%20') + '/'	+ EncodingUtil.urlEncode(City,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address2,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address1,'UTF-8').replaceAll('\\+','%20') + '/ws71-XXXX-XXXX?format=json';
				h = new Http();
				req = new HttpRequest();
				req.setEndpoint(requestURL);
				req.setMethod('GET');
				res = h.send(req);
			}
			catch(Exception ExInner)
			{
				return '{"NetworkError":{"Message": "' + ExInner.getMessage() + '"}}';
			}
		}
        return res.getBody();
    }
    
    
    global Process.PluginDescribeResult describe() { 
    	Process.PluginDescribeResult result = new Process.PluginDescribeResult(); 
        result.Name = 'Service Objects Address Validation Canada';
        result.Tag = 'AddressValidationCanada';
        result.description = 'Covering more than 15.7 million addresses in all 10 provinces and 3 territories, DOTS Address Validation - Canada 2 enables companies to verify, fix and standardize Canadian street addresses. With “auto language detection” this service returns the address in either English or French, with formatting options to return either desired language.';
        result.inputParameters = new 
           List<Process.PluginDescribeResult.InputParameter>{ 
               new Process.PluginDescribeResult.InputParameter('Address 1', 'Address line of the address to validate.  For example, "123 Main Street".',
               Process.PluginDescribeResult.ParameterType.STRING, true),
               new Process.PluginDescribeResult.InputParameter('Address 2', 'The Address2 of the address to validate. This will only be used in particular situations where the Address1 does not help in validating the address.',
               Process.PluginDescribeResult.ParameterType.STRING, false),
               new Process.PluginDescribeResult.InputParameter('City', 'The city of the address to validate. For example, "Toronto".  The city isn\'t required, but if one is not provided, the postal code is required.',
               Process.PluginDescribeResult.ParameterType.STRING, false),
               new Process.PluginDescribeResult.InputParameter('Province','The province of the address to validate.  For example, "ON".  This does not need to be contracted, full province names will work as well.  The province isn\'t required, but if one is not provided, the postal code is required.',
			   Process.PluginDescribeResult.ParameterType.STRING, false),
			   new Process.PluginDescribeResult.InputParameter('Postal Code', 'The postal code of the address to validate.  A postal code isn\'t required, but if one is not provided, the city and province are required.', 
               Process.PluginDescribeResult.ParameterType.STRING, false)
            }; 
        result.outputParameters = new 
            List<Process.PluginDescribeResult.OutputParameter>{
            new Process.PluginDescribeResult.OutputParameter('Address 1', 'The corrected address line 1.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Address 2', 'The corrected address line 2.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('City', 'The corrected city name.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Province', 'The corrected province name.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Postal Code', 'The corrected postal code.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Time Zone', 'The corresponding time zone from the validated address.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Is PO Box', 'The returned Boolean value of a validated address as being a PO Box address.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Station Info', 'The returned Station Name of the Delivery Station.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Delivery Mode', 'The returned Delivery Mode of the address.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Delivery Installation', 'The returned Delivery Installation Type where the final mail sort happens.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Corrections', 'Number that correlates to a Corrections Description. Service Objects may add or change Correction descriptions, but will never modify existing codes.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Corrections Description', 'Description of what was corrected in an address. Service Objects may add or change Correction descriptions, but will never modify existing codes.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Address Number Fragment', 'The parsed address number returned from the validated address. "123" in "123 S. Main Street"',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Street Name Fragment', 'The parsed street name fragment returned from the validated address. "Main" in "123 S. Main Street"',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Street Type Fragment', 'The parsed street type returned from the validated address "Street" in "123 S. Main Street"',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Directional Code Fragment', 'The parsed returned directional code fragment from the validated address.  "S" in "123 S. Main Street" ',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Unit Type Fragment', 'The parsed unit type fragment from the validated address. i.e. "Apt" or "Suite"',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Unit Number Fragment', 'The parsed unit number fragment from the validated address. "1" of "Apt 1"',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Box Number Fragment', 'The returned Box Number from a PO Box address. "1234" of "PO Box 1234"',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Error Type', 'Authorization, User Input, Service Objects Fatal, Domain Specific',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Error Type Code', 'Codes corresponding to the Error Type (1,2,3,4,5)',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Error Description', 'The error description',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Error Description Code', 'Various codes corresponding to the Error Description',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Network Connection Error', 'Tells you there was a general network connection error.',
            Process.PluginDescribeResult.ParameterType.STRING)}; 
        return result;
    }
}