global class AddressValidationUSA3 implements Process.Plugin{
    global Process.PluginResult invoke(Process.PluginRequest request) { 
		String BusinessName = (String) request.inputParameters.get('Business Name');
		String Address1 = (String) request.inputParameters.get('Address 1');
		String Address2 = (String) request.inputParameters.get('Address 2');
		String City = (String) request.inputParameters.get('City');
		String State = (String) request.inputParameters.get('State');
		String ZipCode = (String) request.inputParameters.get('Zip Code');
		
		if(BusinessName == null || BusinessName == '')
		{
			BusinessName = ' ';
		}
		if(Address1 == null || Address1 == '')
		{
			Address1 = ' ';
		}
		if(Address2 == null || Address2 == '')
		{
			Address2 = ' ';
		}
		if(City == null || City == '')
		{
			City = ' ';
		}
		if(State == null || State == '')
		{
			State = ' ';
		}
		if(ZipCode == null || ZipCode == '')
		{
			ZipCode = ' ';
		}

		String ServiceObjectsResult = CallServiceObjectsAPI(BusinessName, Address1, Address2, City, State, ZipCode);
		
 		Map<String,Object> result = new Map<String,Object>();
        Map<String,Object> resultUntyped = (Map<String,Object>)JSON.deserializeUntyped(ServiceObjectsResult);
        List<Object> Addresses = (List<Object>)resultUntyped.get('Addresses');
		
		if(resultUntyped != null)
		{
			result.put('Is CASS', resultUntyped.get('IsCASS'));
		}
		
		if(Addresses != null && Addresses.size() > 0)
		{
			Map<String,Object> addressUntyped;
        
	        Boolean HasAddress = false;
	        
	        for (Object Address : Addresses)
	        {
	        	addressUntyped = (Map<String,Object>)Address;
	        	if(addressUntyped != null)
		        {
		        	HasAddress = true;
	        		result.put('Address 1', addressUntyped.get('Address1'));
	        		result.put('Address 2', addressUntyped.get('Address2'));
	        		result.put('City', addressUntyped.get('City'));
	        		result.put('State', addressUntyped.get('State'));
	        		result.put('Zip Code', addressUntyped.get('Zip'));
	        		result.put('Is Residential', addressUntyped.get('IsResidential'));
	        		result.put('DPV', addressUntyped.get('DPV'));
	        		result.put('DPV Description', addressUntyped.get('DPVDesc'));
	        		result.put('DPV Notes', addressUntyped.get('DPVNotes'));
	        		result.put('DPV Notes Description', addressUntyped.get('DPVNotesDesc'));
	        		result.put('Corrections', addressUntyped.get('Corrections'));
	        		result.put('Corrections Description', addressUntyped.get('CorrectionsDesc'));
	        		result.put('Barcode Digits', addressUntyped.get('BarcodeDigits'));
	        		result.put('Carrier Route', addressUntyped.get('CarrierRoute'));
	        		result.put('Congress Code', addressUntyped.get('CongressCode'));
	        		result.put('County Code', addressUntyped.get('CountyCode'));
	        		result.put('County Name', addressUntyped.get('CountyName'));
	        		result.put('Fragment House', addressUntyped.get('FragmentHouse'));
	        		result.put('Fragment Pre Dir', addressUntyped.get('FragmentPreDir'));
	        		result.put('Fragment Street', addressUntyped.get('FragmentStreet'));
	        		result.put('Fragment Suffix', addressUntyped.get('FragmentSuffix'));
	        		result.put('Fragment Post Dir', addressUntyped.get('FragmentPostDir'));
	        		result.put('Fragment Unit', addressUntyped.get('FragmentUnit'));
	        		result.put('Fragment', addressUntyped.get('Fragment'));
	        		result.put('Fragment PMB Prefix', addressUntyped.get('FragmentPMBPrefix'));
	        		result.put('Fragment PMB Number', addressUntyped.get('FragmentPMBNumber'));
	        		System.debug(result);
		        }
	        	
	        	break;/*Just get the first address*/
	        }
		}
		else
		{
			Object Error = (Object)resultUntyped.get('Error');
			if(Error != null)
			{
				Map<String,Object> errorUntyped = (Map<String,Object>)Error; 
				if(errorUntyped != null)
			    {
			    	result.put('Error Type', errorUntyped.get('Type'));
	        		result.put('Error Type Code', errorUntyped.get('TypeCode'));
	        		result.put('Error Description', errorUntyped.get('Desc'));
	        		result.put('Error Description Code', errorUntyped.get('DescCode'));
			    }
			}
			else
			{
				Object NetworkError = (Object)resultUntyped.get('NetworkError');
				if(NetworkError != null)
				{
					Map<String,Object> networkErrorUntyped = (Map<String,Object>)NetworkError; 
					if(networkErrorUntyped != null)
				    {
				    	result.put('Network Connection Error', networkErrorUntyped.get('Message'));
				    }
				}
			}
		}
        return new Process.PluginResult(result); 
    }
    
    private String CallServiceObjectsAPI(String BusinessName, String Address1, String Address2, String City, String State, String ZipCode)
    {
    	Http h;
		HttpRequest req;
		HttpResponse res;
		String requestURL= 'https://trial.serviceobjects.com/AV3/api.svc/GetBestMatchesJson/' + EncodingUtil.urlEncode(BusinessName,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address1,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address2,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(City,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(State,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(ZipCode,'UTF-8').replaceAll('\\+','%20') + '/ws72-XXXX-XXXX?format=json';

		try
		{
			h = new Http();
			req = new HttpRequest();
			req.setEndpoint(requestURL);
			req.setMethod('GET');
			res = h.send(req);
			Map<String,Object> resultUntyped = (Map<String,Object>)JSON.deserializeUntyped(res.getBody());
			Object Error = (Object)resultUntyped.get('Error');
			
			if(Error != null)
		    {
		    	Map<String,Object> errorUntyped = (Map<String,Object>)Error; 
		    	if(errorUntyped != null && errorUntyped.get('TypeCode') == '3')
		    	{
			    	requestURL= 'https://trial.serviceobjects.com/AV3/api.svc/GetBestMatchesJson/' + EncodingUtil.urlEncode(BusinessName,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address1,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address2,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(City,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(State,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(ZipCode,'UTF-8').replaceAll('\\+','%20') + '/ws72-XXXX-XXXX?format=json';
					h = new Http();
					req = new HttpRequest();
					req.setEndpoint(requestURL);
					req.setMethod('GET');
					res = h.send(req);
		    	}
		    }
		}
		catch(Exception Ex)
		{
			try
			{
				requestURL= 'https://trial.serviceobjects.com/AV3/api.svc/GetBestMatchesJson/' + EncodingUtil.urlEncode(BusinessName,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address1,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(Address2,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(City,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(State,'UTF-8').replaceAll('\\+','%20') + '/' + EncodingUtil.urlEncode(ZipCode,'UTF-8').replaceAll('\\+','%20') + '/ws72-XXXX-XXXX?format=json';
				h = new Http();
				req = new HttpRequest();
				req.setEndpoint(requestURL);
				req.setMethod('GET');
				res = h.send(req);
			}
			catch(Exception ExInner)
			{
				return '{"NetworkError":{"Message": "' + ExInner.getMessage() + '"}}';
			}
		}
        return res.getBody();
    }
    
    
    global Process.PluginDescribeResult describe() { 
    	Process.PluginDescribeResult result = new Process.PluginDescribeResult(); 
        result.Name = 'Service Objects Address Validation USA';
        result.Tag = 'AddressValidationUSA';
        result.description = 'DOTS Address Validation is USPS CASS Certified® and instantly validates, parses, corrects and appends contact address data; includes locational meta-data and the Delivery Point Validation (DPV) operation.  This plugin uses the GetBestMatches operation';
        result.inputParameters = new 
           List<Process.PluginDescribeResult.InputParameter>{ 
               new Process.PluginDescribeResult.InputParameter('Business Name', 'Name of business associated with this address. Used to append Suite data.',
               Process.PluginDescribeResult.ParameterType.STRING, false),
               new Process.PluginDescribeResult.InputParameter('Address 1', 'Address line of the address to validate.  For example, "123 Main Street".',
               Process.PluginDescribeResult.ParameterType.STRING, true),
               new Process.PluginDescribeResult.InputParameter('Address 2', 'This line is for address information that does not contribute to DPV coding an address. For example "C/O John Smith" does not help validate the address, but is still useful in delivery.',
               Process.PluginDescribeResult.ParameterType.STRING, false),
               new Process.PluginDescribeResult.InputParameter('City', 'The city of the address to validate. For example, "New York".  The city isn\'t required, but if one is not provided, the Zip code is required.',
               Process.PluginDescribeResult.ParameterType.STRING, false),
               new Process.PluginDescribeResult.InputParameter('State','The state of the address to validate.  For example, "NY".  This does not need to be contracted, full state names will work as well.  The state isn\'t required, but if one is not provided, the Zip code is required.',
			   Process.PluginDescribeResult.ParameterType.STRING, false),
			   new Process.PluginDescribeResult.InputParameter('Zip Code', 'The zip code of the address to validate.  A zip code isn\'t required, but if one is not provided, the City and State are required.', 
               Process.PluginDescribeResult.ParameterType.STRING, false)
            }; 
        result.outputParameters = new 
            List<Process.PluginDescribeResult.OutputParameter>{
            new Process.PluginDescribeResult.OutputParameter('Address 1', 'The corrected address line 1.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Address 2', 'The corrected address line 2.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('City', 'The corrected city name.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('State', 'The corrected state name.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Zip Code', 'The corrected zip code + 4.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Is Residential', 'Indicates if the address is for a residence.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('DPV', 'Number that correlates to a DPV(Delivery Point Validation) result. An indicator displaying whether or not the address is recognized as deliverable by the USPS.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('DPV Description', 'Explains DPV result.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('DPV Notes', 'Number that correlates to DPV notes description. Service Objects may add or change Note descriptions, but will never modify existing codes.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('DPV Notes Description', 'Details about the DPV result. Service Objects may add or change Note descriptions, but will never modify existing codes.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Corrections', 'Number that correlates to a Corrections Description. Service Objects may add or change Correction descriptions, but will never modify existing codes.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Corrections Description', 'Description of what was corrected in an address. Service Objects may add or change Correction descriptions, but will never modify existing codes.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Barcode Digits', 'The post office delivery barcode digits.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Carrier Route', '4 chars: 1 for the route type, 3 for the route code. Identifies a group of addresses when prepended by 5-digit Zip.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Congress Code', 'The congress code is the congressional district number.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('County Code', 'The county code of the given address.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('County Name', 'The name of the county in which the given address lies.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Fragment House', 'The parsed house number of the given address.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Fragment Pre Direction', 'The parsed pre-directional of the address\'s street.  "North" in "North Main St West".',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Fragment Street', 'The parsed name of the street in the given address.  "Main" in "North Main St West".',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Fragment Suffix', 'The parsed suffix of the street in the given address.  "St" in "North Main St West".',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Fragment Post Dir', 'The parsed post-directional of the address\'s street.  "West" in "North Main St West".',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Fragment Unit', 'The parsed unit type (e.g. "Apt" or "Ste")',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Fragment', 'The parsed "Fragment" box, apartment or unit number. Same as FragmentPMBNumber.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Fragment PMB Prefix', 'The parsed type of the apartment, box, unit, etc.  For example, "APT" or "BOX".',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Fragment PMB Number', 'The parsed apartment, box, unit, etc. number of the given address.',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Error Type', 'Authorization, User Input, Service Objects Fatal, Domain Specific',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Error Type Code', 'Codes corresponding to the Error Type (1,2,3,4)',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Error Description', 'The error description',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Error Description Code', 'Various codes corresponding to the Error Description',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Is CASS', 'Indicates if the unaltered input address is CASS certified. It meets and exceeds all requirements for address correction except bulk mail discounts',
            Process.PluginDescribeResult.ParameterType.STRING),
            new Process.PluginDescribeResult.OutputParameter('Network Connection Error', 'Tells you there was a general network connection error.',
            Process.PluginDescribeResult.ParameterType.STRING)}; 
        return result;
    }
}