/*
'  SERVICE OBJECTS, INC.
'  Service: DOTS Address Validation US
'  Language: APEX Force.com
'  Operation: GetBestMatches
'  Note: The code being suggested in this file provides one possible solution using this particular service. There are
'  many other possible solutions to using this service which may fit a particular problem . Please contact support@serviceobjects.com for more information
' 
'  Date Created:    11/8/2017
'  Last Modified:   11/8/2017
' 
'  Modified by: J. Rehorik
' 
'  WEBSITE
'  http://www.serviceobjects.com
' 
'  PRODUCT PAGE
'  http://www.serviceobjects.com/products/address-geocoding/address-validation-us
' 
'  DEVELOPERS GUIDE
'  https://docs.serviceobjects.com/display/devguide/DOTS+Address+Validation+3+-+US
' 
'  FREE TRIAL
'  http://www.serviceobjects.com/dots-key?wsid=72
' 
'  SUPPORT EMAIL
'  support@serviceobjects.com 
'
'  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
'  OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
'  LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND/OR
'  FITNESS FOR A PARTICULAR PURPOSE.
*/

global class TestUtil {
    
    @future (callout=true)
    public static void CallWSById(List<Id> ContactIds)
    {
    	Http http;
    	HttpRequest request;
    	List<Contact> UpdateListOfContacts = new List<Contact>();
    	for (Id ContactId : ContactIds) {
    		
    		Contact aContact = [SELECT 
    									MailingStreet, 
    									MailingCity, 
    									MailingState, 
    									MailingPostalCode, 
    									id, 
    									AddrValDPVScore__c, 
    									AddrValDPVDescription__c, 
    									AddrValDPVNotes__c, 
    									AddrValIsResidential__c, 
    									AddrValErrorType__c, 
    									AddrValErrorDescription__c  
								FROM Contact 
								WHERE Id=:ContactId LIMIT 1];
								
 		
			http = new Http();
			request = new HttpRequest();
			request.setEndpoint('https://trial.serviceobjects.com/AV3/api.svc/GetBestMatchesJson?BusinessName=&Address='+ EncodingUtil.urlEncode(aContact.MailingStreet,'UTF-8') +
																										     '&Address2=%20&City='+ EncodingUtil.urlEncode(aContact.MailingCity,'UTF-8') +
																										     '&State='+ EncodingUtil.urlEncode(aContact.MailingState, 'UTF-8') +
																										     '&PostalCode='+ EncodingUtil.urlEncode(aContact.MailingPostalCode,'UTF-8') +
																										     '&LicenseKey=ws72-XXXX-XXXX');
			request.setMethod('GET');
			HttpResponse response = http.send(request);
			
			if (response == null)
			{
				http = new Http();
				request = new HttpRequest();
				request.setEndpoint('https://trial.serviceobjects.com/AV3/api.svc/GetBestMatchesJson?BusinessName=&Address='+ EncodingUtil.urlEncode(aContact.MailingStreet,'UTF-8') +
																											     '&Address2=%20&City='+ EncodingUtil.urlEncode(aContact.MailingCity,'UTF-8') +
																											     '&State='+ EncodingUtil.urlEncode(aContact.MailingState, 'UTF-8') +
																											     '&PostalCode='+ EncodingUtil.urlEncode(aContact.MailingPostalCode,'UTF-8') +
																											     '&LicenseKey=ws72-XXXX-XXXX');
				request.setMethod('GET');
				response = http.send(request);
			}
			if (response.getStatusCode() == 200) {
				
				string address1 = '';
				string city = '';
				string state = '';
				string zip = '';
				
				aContact.AddrValErrorType__c = 'None';
				aContact.AddrValErrorDescription__c = 'None';
				
				JSONParser parser = JSON.createParser(response.getBody());
				while (parser.nextToken() != null) {
					if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'Address1')) {
		                parser.nextToken();
		                address1 = parser.getText();
		            }
		            if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'City')) {
		                parser.nextToken();
		                city = parser.getText();
		            }
		            if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'State')) {
		                parser.nextToken();
		                state = parser.getText();
		            }
		            if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'Zip')) {
		                parser.nextToken();
		                zip = parser.getText();
		            }
		            if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'DPV')) {
		                parser.nextToken();
		                aContact.AddrValDPVScore__c = Integer.valueOf(parser.getText());
		            }
		            if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'DPVDesc')) {
		                parser.nextToken();
		                aContact.AddrValDPVDescription__c = parser.getText();
		            }
		            if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'DPVNotesDesc')) {
		                parser.nextToken();
		                aContact.AddrValDPVNotes__c = parser.getText();
		            }
		            if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'IsResidential')) {
		                parser.nextToken();
		                aContact.AddrValIsResidential__c = Boolean.valueOf(parser.getText());
		            }
		            if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'Type')) {
		                parser.nextToken();
		                aContact.AddrValErrorType__c = parser.getText();
		            }
		            if ((parser.getCurrentToken() == JSONToken.FIELD_NAME) && (parser.getText() == 'Desc')) {
		                parser.nextToken();
		                aContact.AddrValErrorDescription__c = parser.getText();
		            }
		        }
		        
		        if(aContact.AddrValDPVScore__c == 1)
                {
                	aContact.MailingStreet = address1;
                	aContact.MailingCity = city;
                	aContact.MailingState = state;
                	aContact.MailingPostalCode = zip;
                }
		        
				UpdateListOfContacts.add(aContact);
			}
			else
			{
				aContact.AddrValErrorDescription__c = 'Error connecting to Service Objects Address Validation API';
			}
		}
		if(UpdateListOfContacts.size() > 0)
		{
			update UpdateListOfContacts;
		}
    }
}